#include "CRfePurInterfaceSettings.h"

#include <reader/QrfeRfePurReader>

CRfePurInterfaceSettings::CRfePurInterfaceSettings(QTextEdit* infoEdit, QWidget* parent)
	: ReaderTabWidget(tr("Interface Settings"), parent)
    , m_reader(0)
{
	ui.setupUi(this);
	setInfoEdit(infoEdit);

	connect(ui.switchCommInterfaceButton,	SIGNAL(clicked()),
			this, 							  SLOT(switchCommInterface()));
	connect(ui.switchCommBaudrateButton,	SIGNAL(clicked()),
			this, 							  SLOT(switchCommBaudrate()));
}

CRfePurInterfaceSettings::~CRfePurInterfaceSettings()
{

}

bool CRfePurInterfaceSettings::init(QrfeReaderInterface* reader)
{
	m_reader = qobject_cast<QrfeRfePurReader*>(reader);
	if( m_reader == 0 )
		return false;

	ulong sw_rev = m_reader->softwareRevision();
	sw_rev &= 0x0000FFFF;
	if(sw_rev < 0x0027)
		return false;

	clearInfo();

	return true;
}

void CRfePurInterfaceSettings::deinit()
{
	m_reader = 0;
}

void CRfePurInterfaceSettings::activated()
{
    if(m_reader == 0)
        return;
}

void CRfePurInterfaceSettings::switchCommInterface ()
{
	if(m_reader == 0)
		return;

	uchar id = ui.switchCommInterfaceBox->currentIndex() + 1;
	QrfeGlobal::Result res = m_reader->switchCommInterface(id);
	if(res == QrfeGlobal::RES_OK)	{
		infoSetOK("-- Switched Communication Interface to " + ui.switchCommInterfaceBox->currentText() + " --\n"
			      "On next power up the reader will communicate using this interface.");
	}
	else {
		infoSetError("-- Could not switch Communication interface --");
	}

}

void CRfePurInterfaceSettings::switchCommBaudrate ()
{
	if(m_reader == 0)
		return;

	ulong baudrate = 0;
	switch(ui.switchCommBaudrateBox->currentIndex())
	{
	default:
	case 0:
		baudrate = 115200; break;
	case 1:
		baudrate = 57600; break;
	case 2:
		baudrate = 38400; break;
	case 3:
		baudrate = 19200; break;
	case 4:
		baudrate = 9600; break;
	}
	QrfeGlobal::Result res = m_reader->switchCommBaudrate(baudrate);
	if(res == QrfeGlobal::RES_OK)	{
		infoSetOK("-- Switched Communication Baudrate to " + QString::number(baudrate) + " --\n"
			      "On next power up the reader will communicate using this baudrate.");
	}
	else {
		infoSetError("-- Could not switch Communication baudrate --");
	}

}

